/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.sharing;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.sharing.ConnectProviderOperation;
import com.aptana.git.ui.internal.sharing.ExistingOrNewPage;
import com.aptana.git.ui.internal.sharing.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.IConfigurationWizardExtension;
import org.eclipse.ui.IWorkbench;

public class SharingWizard
extends Wizard
implements IConfigurationWizard,
IConfigurationWizardExtension {
    IProject[] projects;
    private ExistingOrNewPage existingPage;

    public SharingWizard() {
        this.setWindowTitle(Messages.SharingWizard_Title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IProject project) {
        this.init(workbench, new IProject[]{project});
    }

    public void init(IWorkbench workbench, IProject[] projects) {
        this.projects = new IProject[projects.length];
        System.arraycopy(projects, 0, this.projects, 0, projects.length);
    }

    public void addPages() {
        this.existingPage = new ExistingOrNewPage(this);
        this.addPage((IWizardPage)this.existingPage);
    }

    public boolean performFinish() {
        final ConnectProviderOperation op = new ConnectProviderOperation(this.existingPage.getProjects());
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        op.run(monitor);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            });
            return true;
        }
        catch (Throwable e) {
            IStatus status;
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof CoreException) {
                status = ((CoreException)e).getStatus();
                e = status.getException();
            } else {
                status = new Status(4, GitPlugin.getPluginId(), 1, Messages.SharingWizard_failed, e);
            }
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (String)Messages.SharingWizard_failed, (Throwable)e, (String)"com.aptana.git.core/debug");
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)this.getWindowTitle(), (String)Messages.SharingWizard_failed, (IStatus)status, (int)status.getSeverity());
            return false;
        }
    }

    public boolean canFinish() {
        return this.existingPage.isPageComplete();
    }
}

